#!/usr/bin/env python
# encoding=utf-8

from django.core.management import BaseCommand
from api.models import Diary
from gm_types.gaia import ORDER_STATUS

class Command(BaseCommand):

    def handle(self, *args, **options):
        diarys = Diary.objects.filter(order__status=ORDER_STATUS.REFUNDED, topics__isnull=True, rate_count=0, is_online=True)
        for diary in diarys:
            diary.is_online = False
            diary.save()