# coding=utf-8
from django.core.management import BaseCommand
from api.models import Problem
from gm_types.gaia import PROBLEM_REVIEW_STATUS_CHOICES


class Command(BaseCommand):

    def handle(self, *args, **options):
        problems = Problem.objects.exclude(review_status=PROBLEM_REVIEW_STATUS_CHOICES.OK, is_online=True).iterator()
        for problem in problems:
            problem.set_review_status(problem.images.count())
            print problem.id
