#!/usr/bin/env python
# encoding=utf-8

from django.core.management import BaseCommand
from api.models import Service
from gm_types.plutus import INSURANCE_TYPE
from gm_types.gaia import YINUO_TYPE
from rpc.all import get_rpc_remote_invoker


class Command(BaseCommand):
    def handle(self, *args, **options):
        rpc = get_rpc_remote_invoker()
        options = {
            'columns': [
                'id',
                'insurance_type',
                'product_id',
                'name',
                'premium',
                'premium'
            ],
            'filters': [],
            'orders': [],
            'paging': {'length': 100, 'need_count': True, 'start': 0},
            'search': None
        }
        dic = rpc['plutus/insurance/hera/service_list'](options=options).unwrap()
        data = dic['data']
        for d in data:
            print d
            if d['insurance_type'] == INSURANCE_TYPE.ZHONGAN:
                print Service.objects.filter(zhongan_type=d['product_id']).update(insurance=d['id'])
            elif d['insurance_type'] == INSURANCE_TYPE.YINUO:
                print Service.objects.filter(yinuo_type=YINUO_TYPE.CASUALTY).update(insurance=d['id'])
            else:
                print('?????')
        print 'Done'
