# coding=utf-8
from django.core.management import BaseCommand

from api.models import SpecialSeckillService


class Command(BaseCommand):
    """
    同步专题美购抽成数据, python manage.py update_sekill_discount update
    """

    def add_arguments(self, parser):
        parser.add_argument('param', nargs='+', type=str)

    def handle(self, *args, **options):
        print options
        for item in options['param']:
            if item == 'update':
                Process.data_save()
            elif item == 'test':
                Process.data_test()


class Process():
    @staticmethod
    def data_save():
        file_log = open('dachuservice/3.txt', 'r')
        result_log = open('0813_sekill.txt', 'a')
        lines = file_log.readlines(100000)
        for line in lines:
            try:
                service_id = int(line)
                sekill_service = SpecialSeckillService.objects.filter(service_id=service_id)
                for item in sekill_service:
                    item.seckill_price -= 11
                    item.commission -= 11
                    item.pre_payment_price -= 11
                    item.save()
                    message = str(item.id) + u',' + str(item.seckill_price) + u',' + str(item.commission) + u',' + \
                          str(item.pre_payment_price) + u'\n'
                    print message
                    result_log.writelines(message)
            except Exception as e:
                print e.message
                continue
        print (u"更新成功!")
        file_log.close()
        result_log.close()

    @staticmethod
    def data_test():
        file_log = open('dachuservice/3.txt', 'r')
        lines = file_log.readlines(100000)
        for line in lines:
            try:
                service_id = int(line)
                sekill_service = SpecialSeckillService.objects.filter(service_id=service_id)
                for item in sekill_service:
                    item.seckill_price -= 11
                    item.commission -= 11
                    item.pre_payment_price -= 11
                    message = str(item.id) + u',' + str(item.seckill_price) + u',' + str(item.commission) + u',' + \
                          str(item.pre_payment_price) + u'\n'
                    print message
            except Exception as e:
                print e.message
                continue
        print (u"测试一下没问题!请继续执行python manage.py update_sekill_discount update")
        file_log.close()
