#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2019/5/30
import json
from django.db.models import Q
from django.conf import settings
from api.models.doctor import Doctor
from django.core.management import BaseCommand

from api.models import Service, ServiceRegister, ServiceItem, ServiceItemKey, AttrOptions

replace_dict = {
    # u"水光针": u"水光针导入",
    # u"热玛吉": u"提拉紧致",
    # u"超声刀": u"提拉紧致",
    # u"线雕": u"面部提升",
    # u"韩式双眼皮": u"双眼皮",
    # u"欧式芭比眼": u"双眼皮",
    # u"达拉斯鼻": u"隆鼻",
    # u"美人雕": u"隆鼻",
    # u"逆龄术": u"补水保湿",
    # u"冻龄术": u"补水保湿",
    # u"童颜针": u"其他填充物",
    # u"瘦脸针": u"除皱瘦脸",
    # u"科技创新奖": u"",
    # u"有效率": u"",
    # u"成功率": u"",
    # u"最高级": u"",
    # u"世界级": u"",
    # u"顶级": u"",
    # u"韩国顶尖": u"",
    # u"微拉美": u"",
    # u"全球顶尖": u"",
    # u"干细胞": u"",
    # u"名牌": u"",
    # u"优秀": u"",
    # u"资深": u"",
    # u"著名": u"",
    # u"金牌": u"",
    # u"最好": u"",
    # u"最佳": u"",
    # u"首席": u"",
    # u"国家级": u"",
    # u"亚洲": u"",
    # u"外籍及港澳台": u"",
    # u"美白针": u"",
    # u"最先进": u"",
    # u"隐形无托槽矫正技术隐形无托槽矫正技术": u"",
    # u"无痛微创种植牙技术无痛微创种植牙技术": u"",
    # u"PRP": u"",
    # u"溶脂针": u"",
    # u"精雕": u"",
    # u"玻尿酸酶": u"",
    # u"成活率": u"",
    # u"安全": u"",
    # u"专利": u"",
    # u"prp": u"",
    # u"菲洛嘉": u"",

    u"水光针导入": u"水光导入",
    u"水光针": u"水光导入",
    u"热玛吉": u"提拉紧致",
    u"超声刀": u"提拉紧致",
    u"热拉提": u"提拉紧致",
    u"瘦脸针": u"除皱瘦脸",
    u"鼻部综合": u"鼻部多项",
    u"眼部综合": u"眼部多项",
    u"鼻综合": u"鼻部多项",
    u"眼部套餐": u"眼部多项",
    u"溶脂针瘦脸": u"溶脂瘦脸",
    u"自体脂肪全面部填充": u"自体脂肪面部填充",
    u"内切祛眼袋": u"内切去眼袋",
    u"外切祛眼袋": u"外切去眼袋",
    u"祛眼袋": u"去眼袋",
    u"激光祛腋臭": u"激光治疗腋臭",
    u"玻尿酸除颈纹": u"玻尿酸",
    u"祛痣": u"点痣",
    u"祛痘祛痘印": u"淡化痘印",
    u"果酸焕肤": u"果酸嫩肤",
    u"自体脂肪丰臀": u"自体脂肪形体雕塑",
    u"自体脂肪隆胸": u"自体脂肪形体雕塑",
    u"祛疤": u"去疤痕",
}

class Command(BaseCommand):

    def handle(self, *args, **kwargs):
        print("start to amend service name")

        doctor_ids = list(Doctor.objects.using(settings.SLAVE_DB_NAME).filter(hospital__city_id="shanghai").values_list("id", flat=True))

        service_amend_info, serviceregister_info, tag_info = {}, {}, {}
        print("------------start to amend service info------------")
        for w, f in replace_dict.iteritems():
            for s in Service.objects.filter((Q(name__contains=w) | Q(short_description__contains=w)) & Q(doctor_id__in=doctor_ids)):
                service_amend_info[s.id] = {'name': s.name, "short_description": s.short_description}
                print(u'origin: [{id}]:[{name}]:[{short_description}]'.format(id=s.id, name=s.name,
                                                                              short_description=s.short_description))
                s.name = s.name.replace(w, f)
                if s.short_description:
                    s.short_description = s.short_description.replace(w, f)
                s.save()
                print(u'replace: [{id}]:[{name}]:[{short_description}]'.format(id=s.id, name=s.name,
                                                                               short_description=s.short_description))
        print("------------end amend service info------------")


        print("------------start to amend serviceregister info------------")
        for w, f in replace_dict.iteritems():
            for sr in ServiceRegister.objects.filter((Q(name__contains=w) | Q(short_description__contains=w)) & Q(doctor_id__in=doctor_ids)):
                print(u'origin: [{id}]:[{short_description}]'.format(id=sr.id, short_description=sr.short_description))
                serviceregister_info[sr.id] = sr.short_description
                if sr.short_description:
                    sr.short_description = sr.short_description.replace(w, f)
                sr.name = sr.name.replace(w, f)
                sr.save()
                print(u'replace: [{id}]:[{short_description}]'.format(id=sr.id, short_description=sr.short_description))
        print("------------end amend serviceregister info------------")


        print("------------start to AttrOptions info------------")

        options_info = {}
        service_ids = list(Service.objects.using(settings.SLAVE_DB_NAME).filter(Q(doctor_id__in=doctor_ids)).values_list("id", flat=True))
        service_item_ids = list(ServiceItem.objects.using(settings.SLAVE_DB_NAME).filter(service_id__in=service_ids).values_list("id", flat=True))
        serviceattroption_ids = list(ServiceItemKey.objects.using(settings.SLAVE_DB_NAME).filter(serviceitem_id__in=service_item_ids).values_list("serviceattroption_id", flat=True))
        for w, f in replace_dict.iteritems():
            for op in AttrOptions.objects.filter(Q(id__in=serviceattroption_ids) & Q(name__contains=w)):
                print(u'origin: [{id}]:[{name}]'.format(id=op.id, name=op.name))
                options_info[op.id] = op.name
                op.name = op.name.replace(w, f)
                op.save()
                print(u'replace: [{id}]:[{name}]'.format(id=op.id, name=op.name))

        print("------------end amend serviceregister info------------")


        print("------------start to write log------------")

        write_str = json.dumps(service_amend_info) + '\\n' + json.dumps(serviceregister_info)+ '\\n' + json.dumps(options_info)

        with open("replace-names.log", "w+") as f:
            f.write(write_str)

        print("------------------write log end ------------------------")
