# coding=utf-8
from django.db import models
from api.models import Slide, City, Region


class ShowCity(models.Model):
    class Meta:
        verbose_name = u'展现城市'
        db_table = 'api_show_city'
        app_label = 'api'

    city = models.ForeignKey(City, verbose_name=u"城市ID", help_text=u"城市ID")
    create_time = models.DateTimeField(verbose_name=u'创建时间', auto_now_add=True)
    slide = models.ForeignKey(Slide, verbose_name=u"轮播Slide的ID", related_name='related_slide')


class ShowRegion(models.Model):
    class Meta:
        verbose_name = u'展示大区'
        app_label = 'api'

    region = models.ForeignKey(Region, verbose_name=u'展示大区')
    create_time = models.DateTimeField(verbose_name=u'创建时间', auto_now_add=True)
    slide = models.ForeignKey(Slide, verbose_name=u'轮播slideID', related_name='showregion')


class CityScale(models.Model):
    class Meta:
        verbose_name = u'城市“桶”内容按比混合'
        app_label = 'api'

    city = models.OneToOneField(City)
    native = models.PositiveIntegerField(u'本地', default=0)
    nearby = models.PositiveIntegerField(u'临近城市', default=0)
    nation = models.PositiveIntegerField(u'全国', default=0)
    megacity = models.PositiveIntegerField(u'特大城市', default=0)


class CityScaleNeabyCity(models.Model):
    class Meta:
        verbose_name = u'内容按比例混合-可选临近城市'
        app_label = 'api'
        db_table = 'api_cityscale_nearby_city'

    cityscale = models.ForeignKey(CityScale, related_name='nearby_cities')
    nearby_city = models.ForeignKey(City, verbose_name=u'临近城市')


class TransactionNearbyCity(models.Model):
    class Meta:
        verbose_name = u'邻近城市表-交易部分'
        db_table = 'api_transaction_nearby_city'

    city = models.ForeignKey(City, verbose_name=u'当前城市', related_name='city')
    nearby_city = models.ForeignKey(City, verbose_name=u'邻近城市', related_name='nearby_city')


class TransactionNearbyCityToES(models.Model):
    class Meta:
        verbose_name = u'邻近城市表-交易部分-搜索逻辑'
        db_table = 'api_transaction_nearby_city_to_es'

    city = models.ForeignKey(City, verbose_name=u'当前城市', related_name='es_city')
    nearby_city = models.ForeignKey(City, verbose_name=u'邻近城市', related_name='es_nearby_city')