# -*- coding: utf-8 -*-
import datetime
import traceback
import logging
# from __future__ import unicode_literals, absolute_import, print_function
from django.db import models
from .types import TAG_TYPE
from django.db.models import TextField, ForeignKey, IntegerField, CharField, SmallIntegerField
from django.db.models import BooleanField, DateTimeField, URLField, OneToOneField
from wiki.models.collect import CollectTag


class CollectWiki(models.Model):
    class Meta:
        verbose_name = u'聚合新百科'
        db_table = 'wiki_collect'

    id = models.IntegerField(verbose_name=u'聚合ID', primary_key=True)
    name = CharField(u'聚合名称', max_length=48)
    description = TextField(u'简介')
    is_online = BooleanField(u'是否上线', default=True)
    create_time = models.DateTimeField(verbose_name=u'创建时间', default=datetime.datetime.fromtimestamp(0))

    def get_old_tag_ids_collect(self):
        try:
            old_tags_ids = list(CollectTag.objects.filter(collect=self.id).values_list("tag", flat=True))
            return old_tags_ids
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return []

    @property
    def get_collect_old_tag(self):

        try:
            old_tags_lists = list(CollectTag.objects.filter(collect=self.id, tag__tag_type__in=[TAG_TYPE.BODY_PART,
                                                                                                TAG_TYPE.BODY_PART_SUB_ITEM,
                                                                                                TAG_TYPE.ITEM_WIKI]).values_list(
                "tag__name", flat=True))
            return old_tags_lists

        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return []
