# coding=utf-8
from django.db import models

from api.models.itemwiki import ItemWiki
from gm_upload import IMG_TYPE, ImgUrlField
from api.models import Tag

class ConsultWiki(models.Model):
    class Meta:
        verbose_name = '咨询百科'
        db_table = 'api_consult_wiki'
        app_label = 'api'

    wiki = models.ForeignKey(ItemWiki, verbose_name=u'关联的wiki', null=False)
    icon = ImgUrlField(img_type=IMG_TYPE.CONSULTWIKI, max_length=1024, verbose_name=u'icon', null=False)
    ordering = models.IntegerField(verbose_name=u'展示顺序', help_text=u'小的排在前，大的排在后', default=0)
    is_online = models.BooleanField(verbose_name='是否上线', default=True)


class ConsultScience(models.Model):
    class Meta:
        verbose_name = '科普知识'
        db_table = 'api_consult_science'
        app_label = 'api'

    desc = models.CharField(verbose_name=u'主题描述', max_length=128, null=True, blank=True, default='')
    image = models.CharField(verbose_name=u'图片地址', max_length=256)
    is_online = models.BooleanField(verbose_name='是否上线', default=True)
    wiki = models.OneToOneField(ItemWiki, verbose_name='相关wiki')


class ConsultScienceWiki(models.Model):
    class Meta:
        app_label = 'api'

    consult_science = models.ForeignKey(ConsultScience,related_name='related_wikis')
    wiki = models.ForeignKey(ItemWiki)


class ConsultTheme(models.Model):
    class Meta:
        verbose_name = '精选主题'
        db_table = 'api_consult_theme'
        app_label = 'api'

    desc = models.CharField(verbose_name=u'主题描述', max_length=128, null=True, blank=True, default='')
    title = models.CharField(verbose_name=u'主题标题', max_length=128, null=True, blank=True, default='')
    image = models.CharField(verbose_name=u'图片地址', max_length=256)
    is_online = models.BooleanField(verbose_name='是否上线', default=True)


class ConsultThemeWiki(models.Model):
    class Meta:
        app_label = 'api'

    consult_theme = models.ForeignKey(ConsultTheme,related_name='related_wikis')
    slogan = models.CharField(verbose_name=u'主题描述', max_length=128, null=True, blank=True, default='')
    image = models.CharField(verbose_name=u'图片地址', max_length=256)
    wiki = models.ForeignKey(ItemWiki)

