# -*- coding: utf-8 -*-

from __future__ import absolute_import, unicode_literals

from django.db import models
from gm_types.gaia import CARD_TYPE, SLIDE_USER_TYPE, LOADING_POSITION


class IndexFeed(models.Model):
    class Meta:
        verbose_name = u'首页运营位调整'
        db_table = 'api_indexfeed'
        app_label = 'api'
        unique_together = ('ordering', 'loading', 'user_type')

    ordering = models.IntegerField(default=999999, verbose_name=u"展示顺序", help_text=u"小的排在前，大的排在后")
    loading = models.CharField(u'加载次数', max_length=2, choices=LOADING_POSITION, default=LOADING_POSITION.FIRST)
    card = models.CharField(u'卡片类型', max_length=2, choices=CARD_TYPE, default=CARD_TYPE.SELECTDIARY)
    user_type = models.CharField(max_length=2, choices=SLIDE_USER_TYPE, default=SLIDE_USER_TYPE.ALL_USER)
    is_online = models.BooleanField(default=False, help_text=u"是否上线", verbose_name=u"上线")
    created_time = models.DateTimeField(auto_now_add=True, verbose_name=u'添加时间')






