# coding: utf-8

from django.db.models import Model
from django.db.models import ForeignKey, IntegerField, BooleanField, DateTimeField

from api.models import Merchant


class KaBalance(Model):
    class Meta:
        verbose_name = u'Ka收入比例'
        app_label = 'api'

    merchant = ForeignKey(Merchant, verbose_name=u'商户')
    radio = IntegerField(u'比例', default=0)
    is_online = BooleanField(u"是否下线", default=True)
    start_time = DateTimeField(u'开始日期')
    end_time = DateTimeField(u'结束日期', null=True)
    create_time = DateTimeField(auto_now_add=True)
    update_time = DateTimeField(u'最后更新时间', auto_now=True)
