# coding=utf-8
from django.db import models
from django.utils import timezone
from gm_upload import ImgUrlField, IMG_TYPE
from gm_types.gaia import SIGN_USER_ACTION
from django.contrib.auth.models import User


class SignActivity(models.Model):
    class Meta:
        verbose_name = u'签到活动'
        db_table = 'api_sign_activity'
        app_label = 'api'

    name = models.CharField(max_length=100, verbose_name=u'名称', default="")
    start_time = models.DateTimeField(verbose_name=u'开始时间')
    end_time = models.DateTimeField(verbose_name=u'结束时间')
    rule = models.TextField(max_length=2048, verbose_name=u'活动规则', default="", null=True)
    banner = models.TextField(verbose_name=u'banner图', null=True)
    is_online = models.BooleanField(verbose_name=u'是否在线', default=True)
    created_time = models.DateTimeField(auto_now_add=True, verbose_name=u'创建时间')
    updated_time = models.DateTimeField(verbose_name=u'更新时间', auto_now=True)


class SignAllRecord(models.Model):
    class Meta:
        verbose_name = u'签到活动记录'
        db_table = 'api_sign_record'
        app_label = 'api'

    user = models.ForeignKey(User, verbose_name=u'用户')
    activity = models.ForeignKey(SignActivity, verbose_name=u'签到活动')
    sign_time = models.DateTimeField(verbose_name=u'签到时间', default=timezone.now)
    sign_type = models.CharField(verbose_name=u'签到类型', default=SIGN_USER_ACTION.TO_SIGN, choices=SIGN_USER_ACTION, max_length=4)
    created_time = models.DateTimeField(auto_now_add=True, verbose_name=u'创建时间')
    updated_time = models.DateTimeField(verbose_name=u'更新时间', auto_now=True)


class UserLastSignRecord(models.Model):
    class Meta:
        verbose_name = u'用户连续签到记录'
        db_table = 'api_last_sign_record'
        app_label = 'api'

    user = models.ForeignKey(User, verbose_name=u'用户')
    activity = models.ForeignKey(SignActivity, verbose_name=u'签到活动')
    start_time = models.DateTimeField(verbose_name=u'开始签到时间')
    end_time = models.DateTimeField(verbose_name=u'该次签到结束时间')
    days_count = models.IntegerField(verbose_name=u'连续签到的天数', default=1)
    available_days = models.IntegerField(verbose_name=u'用户可兑换的天数', default=1)
    is_new = models.BooleanField(verbose_name=u'是否是用户当前签到', default=True)
    created_time = models.DateTimeField(auto_now_add=True, verbose_name=u'创建时间')
    updated_time = models.DateTimeField(verbose_name=u'更新时间', auto_now=True)


class SignPrize(models.Model):
    class Meta:
        verbose_name = u'签到活动奖品'
        db_table = 'api_sign_prize'
        app_label = 'api'

    name = models.CharField(max_length=256, verbose_name=u'全称')
    short_name = models.CharField(max_length=100, verbose_name=u'简称')
    img_url = ImgUrlField(img_type=IMG_TYPE.NOWATERMARK, verbose_name=u'奖品图片', max_length=256)
    price = models.FloatField(default=0, verbose_name=u'市场价')
    total = models.IntegerField(default=0, verbose_name=u'总数量')
    count = models.IntegerField(default=0, verbose_name=u'现有数量')
    created_time = models.DateTimeField(auto_now_add=True, verbose_name=u'创建时间')
    updated_time = models.DateTimeField(verbose_name=u'更新时间', auto_now=True)


class ActivityPrize(models.Model):
    class Meta:
        verbose_name = u'签到活动与奖品关系表'
        db_table = 'api_activity_prize_relation'
        app_label = 'api'

    activity = models.ForeignKey(SignActivity, verbose_name=u'签到活动')
    prize = models.ForeignKey(SignPrize, verbose_name=u'签到奖品', null=True)
    cost = models.IntegerField(verbose_name=u'兑换条件(签到的天数)', default=0)
    total = models.IntegerField(verbose_name=u'总库存', default=0)
    count = models.IntegerField(verbose_name=u'当前数量', default=0)
    created_time = models.DateTimeField(auto_now_add=True, verbose_name=u'创建时间')
    updated_time = models.DateTimeField(verbose_name=u'更新时间', auto_now=True)


class UserReceive(models.Model):
    class Meta:
        verbose_name = u'用户领取奖品'
        db_table = 'api_user_receive_prize'
        app_label = 'api'

    user_id = models.IntegerField(verbose_name=u'用户')
    activity = models.ForeignKey(SignActivity, verbose_name=u'签到活动')
    prize = models.ForeignKey(SignPrize, verbose_name=u'签到奖品')
    count = models.IntegerField(verbose_name=u'奖品的数量', default=0)
    express_no = models.CharField(u'快递号', max_length=100)
    user_name = models.CharField(u'用户名', max_length=64)
    user_phone = models.CharField(u'用户手机号', max_length=32, default="", null=True)
    user_address = models.CharField(u'用户地址', max_length=128, default="", null=True)
    created_time = models.DateTimeField(auto_now_add=True, verbose_name=u'创建时间')
    updated_time = models.DateTimeField(verbose_name=u'更新时间', auto_now=True)


class SignConfig(models.Model):
    class Meta:
        verbose_name = u'签到活动配置'
        db_table = 'api_sign_activity_config'
        app_label = 'api'

    enter_switch = models.BooleanField(default=False, verbose_name=u'入口开关')
    float_window_switch = models.BooleanField(default=False, verbose_name=u'悬浮窗开关')
    routine_icon = ImgUrlField(img_type=IMG_TYPE.NOWATERMARK, verbose_name=u'常规签到icon', max_length=256)
    space_icon = ImgUrlField(img_type=IMG_TYPE.NOWATERMARK, verbose_name=u'断签icon', max_length=256)
    created_time = models.DateTimeField(auto_now_add=True, verbose_name=u'创建时间')
    updated_time = models.DateTimeField(verbose_name=u'更新时间', auto_now=True)


class SignActivityUserStatus(models.Model):
    class Meta:
        verbose_name = u'签到活动用户状态信息'
        db_table = 'api_sign_user_status'
        app_label = 'api'
        unique_together = ('user', 'activity')

    user = models.ForeignKey(User, verbose_name=u'用户')
    activity = models.ForeignKey(SignActivity, verbose_name=u'签到活动')
    is_remind = models.BooleanField(verbose_name=u'签到提醒', default=False)
    has_window = models.BooleanField(verbose_name=u'是否有弹窗(一生一次)', default=False)
    # 7755 补签改成根据轮次
    add_sign_number = models.IntegerField(verbose_name=u'补签数(当期活动)', default=0)
    created_time = models.DateTimeField(auto_now_add=True, verbose_name=u'创建时间')
    updated_time = models.DateTimeField(verbose_name=u'更新时间', auto_now=True)


class UserLastSign(models.Model):
    class Meta:
        verbose_name = u'用户连续签到表'
        db_table = 'api_newest_sign'
        app_label = 'api'
        unique_together = ('user', 'activity')

    user = models.ForeignKey(User, verbose_name=u'用户')
    activity = models.ForeignKey(SignActivity, verbose_name=u'签到活动')
    newest_time = models.DateField(verbose_name=u'最近签到时间(当前轮次)', null=True)
    days_count = models.IntegerField(verbose_name=u'连续签到天数(当前轮次)', default=1)
    available_days = models.IntegerField(verbose_name=u'连续签到可用天数(当前轮次)', default=1)
    share_code = models.CharField(verbose_name=u'分享码(当前轮次)', max_length=18, null=True)
    add_sign_number = models.IntegerField(verbose_name=u'补签数(当前轮次)', default=0)
    created_time = models.DateTimeField(auto_now_add=True, verbose_name=u'创建时间')
    updated_time = models.DateTimeField(verbose_name=u'更新时间', auto_now=True)