# -*- coding: utf-8 -*-

from django.db import models
from django_bulk_update.manager import BulkUpdateManager

from api.models import Service
from api.models import BaseModel


class SmartRank(models.Model):
    objects = BulkUpdateManager()

    class Meta:
        verbose_name = u'美购smart_rank值'
        db_table = 'api_smart_rank'
        app_label = 'api'

    service = models.OneToOneField(Service, null=True, verbose_name=u'关联美购')
    smart_rank = models.FloatField(default=0, help_text=u"推荐相关系数")
    price_data = models.TextField(default='', null=True, blank=True, verbose_name=u"相对值")
    new_smart_rank = models.FloatField(default=0, help_text=u"新推荐相关系数")
    update_time = models.DateTimeField(verbose_name=u'最后更新时间', auto_now=True)
    smart_rank_v4 = models.FloatField(default=0, help_text=u"推荐相关系数v4")


class ManualIndex(models.Model):
    class Meta:
        verbose_name = u'人工指数'
        db_table = 'api_manual_index'
        app_label = 'statistic'

    service = models.OneToOneField(Service, null=True, verbose_name=u'关联美购')
    index = models.IntegerField(verbose_name=u'人工指数, [-120,120]')


class SmartRankCompare(models.Model):
    objects = BulkUpdateManager()
    class Meta:
        verbose_name = u'人工指数对比'
        db_table = 'api_smart_rank_compare'
        app_label = 'api'
        index_together = [('check_time', 'srn_delta')]

    service_id = models.IntegerField(verbose_name=u'美购ID', db_index=True)
    check_time = models.DateTimeField(verbose_name=u'检查时间', auto_now_add=True)
    mysql_smart_rank = models.FloatField(default=0, help_text=u"mysql推荐相关系数")
    es_smart_rank = models.FloatField(default=0, help_text=u"es推荐相关系数")
    mysql_new_smart_rank = models.FloatField(default=0, help_text=u"mysql新推荐相关系数")
    es_new_smart_rank = models.FloatField(default=0, help_text=u"es新推荐相关系数")
    sr_delta = models.FloatField(default=0, help_text=u"mysql_smart_rank - es_smart_rank")
    srn_delta = models.FloatField(default=0, help_text=u"mysql_new_smart_rank - es_new_smart_rank")



class SmartRankFactor(BaseModel):
    class Meta:
        verbose_name = u'美购smart_rank因子'
        verbose_name_plural = verbose_name
        db_table = 'api_smart_rank_factor'

    service_id = models.IntegerField(verbose_name=u'美购ID', unique=True)
    discount_value = models.FloatField(verbose_name=u'折扣', default=0)
    cpt_value = models.FloatField(verbose_name=u'cpt_value', default=0)
    click_price = models.FloatField(verbose_name=u'点击价格', default=0)
    consult_value = models.FloatField(verbose_name=u'咨询价格', default=0)
    ctr_value = models.FloatField(verbose_name=u'ctr_value', default=0)
    discount_value_v4 = models.FloatField(verbose_name=u'折扣v4', default=0)
