# -*- coding:utf-8 -*-
from celery import shared_task
from gm_types.gaia import SCAN_TYPE
from api.models.face import SkinResult, ScanRecord
from django.db.models import Q


@shared_task
def rectify_client_record_task(user_id=None, device_id=None):
    """客户端ai缓存"""

    if not (user_id or device_id):
        return {}

    query = Q(device_id=device_id)

    if user_id:
        query = Q(user_id=user_id)

    SkinResult.objects.filter(query).update(client_cache=False)
    ScanRecord.objects.filter(query, scan_type__in=[SCAN_TYPE.SCAN_FACE, SCAN_TYPE.SCAN_FACE_OLD]).update(
        client_cache=False)
