#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2019/7/23


def validate_order_log(order_id):
    """
    验证订单埋点
    :param order_id:
    :return:
    """
    return {
        'event_type': "validate_order",
        'info': {
            'order_id': order_id,
        },
    }


def add_to_shopcart(service_id, user_id):
    """
    美购添加到购物车
    :param service_id:
    :return:
    """
    return {
        'event_type': "add_shopcart",
        'info': {
            'service_id': service_id,
            'user_id': user_id,
        }
    }


def paid_success(order_ids):
    """
    结算成功
    :param order_ids: ["312432412412", "234124312341"]
    :return:
    """
    return {
        "event_type": "paid_success",
        'info': {
            "order_ids": order_ids
        }
    }


def budan_record(user_id, order_id, service_id, dev_projects):
    """
    一般补单埋点数据
    :param user_id:
    :param order_id:
    :param service_id:
    :param dev_projects:
    :return:
    """
    return {
        "event_type": "budan_record",
        "info": {
            "user_id": user_id,
            "order_id": order_id,
            "service_id": service_id,
            "dev_projects": dev_projects,

        }
    }


def bdtransfer_record(user_id, tags):
    """
    转诊补单埋点
    :param user_id:
    :param tags:
    :return:
    """
    return {
        "event_type": "bdtransfer_record",
        "info": {
            "user_id": user_id,
            "tags": tags
        }
    }