# coding=utf-8

import json

from rpc.cache import consult_cache
from rpc.tool.log_tool import info_logger


class ConsultConfig(object):
    """
    咨询模块配置
    """
    key = 'consult'
    default_config = {
        'show_wiki': True,  # 是否显示百科
        'show_self_consult': True  # 是否显示自助问诊
    }

    @classmethod
    def get(cls):
        try:
            config = json.loads(consult_cache.get(cls.key))
        except:
            config = cls.default_config
        return config

    @classmethod
    def set(cls, new_config):
        if not new_config:
            return

        config = cls.get()
        for k, v in new_config.items():
            if k in config:
                config[k] = v

        try:
            consult_cache.set(cls.key, json.dumps(config))
        except:
            info_logger.error(u'设置咨询配置失败')
