# coding=utf-8

__author__ = 'leaf'

from gm_types.gaia import TOPIC_TYPE

from api.tool.log_tool import logging_exception
from rpc.decorators import cache_page
from rpc.all import get_rpc_remote_invoker


@cache_page(300)
def get_index_banner_topic_info_by_ids(topic_ids):
    try:
        rpc_invoker = get_rpc_remote_invoker()
        result = rpc_invoker['topic/get_index_banner_topic_by_ids'](topic_ids=topic_ids).unwrap()
        result_final = {}
        for k, v in result.iteritems():
            result_final[int(k)] = v
        return result_final

    except:
        logging_exception()
        return {}


def get_topic_info_by_ids(topic_ids):
    try:
        rpc_invoker = get_rpc_remote_invoker()
        topics = rpc_invoker['topic/list_data_get_by_ids'](ids=topic_ids).unwrap()
        datas = topics['topics']
        result = []
        for data in datas:
            if data['problem']['topic_type'] != TOPIC_TYPE.COLUMN_ARTICLE:
                result.append(data)
        return result

    except:
        logging_exception()
