# -*- coding:utf-8 -*-
'''
对外提供用户接口服务
'''

import json

from rpc.decorators import bind
from api.util.user_util import simple_user_info_by_user_ids, simple_doctor_info_by_user_ids


@bind('api/user/simple_user_info')
def get_simple_user_info(user_ids):
    '''
    批量获取简单用户数据
    user_ids: 用户id列表
    return:
        {   int:  dict
            uid1: {},
            uid2: {}
        }
    '''
    s_user_info = simple_user_info_by_user_ids(user_ids)
    s_doc_info = simple_doctor_info_by_user_ids(user_ids)
    for k, v in s_user_info.items():
        dv = s_doc_info.get(k)
        if dv:
            v['doc_info'] = dv
    return s_user_info
