# coding=utf-8
from __future__ import unicode_literals

from rpc.decorators import bind

from api.models.doctor_intelligence import DoctorIntelligence


@bind('api/doctor_intelligence/get_info')
def get_doctor_intelligence_info(province, doctor_name, hospital_name):
    try:
        doctor = DoctorIntelligence.objects.get(province=province, doctor_name=doctor_name, hospital_name=hospital_name)
        return doctor.data()
    except DoctorIntelligence.DoesNotExist:
        return {}


@bind('api/doctor_intelligence/insert_info')
def insert_doctor_intelligence_info(province, doctor_name, hospital_name, sex, level, pro_class, pro_cert_no,
                                    pro_location, pro_scope, cert_grant_org):
    try:
        DoctorIntelligence.objects.get(province=province, doctor_name=doctor_name, hospital_name=hospital_name)
        pass
    except DoctorIntelligence.DoesNotExist:
        data = {
            'province': province,
            'doctor_name': doctor_name,
            'hospital_name': hospital_name,
            'sex': sex,
            'level': level,
            'pro_class': pro_class,
            'pro_cert_no': pro_cert_no,
            'pro_location': pro_location,
            'pro_scope': pro_scope,
            'cert_grant_org': cert_grant_org,
        }
        DoctorIntelligence(**data).save()

    return {'data': 'ok'}


