# coding=utf-8
from rpc.decorators import bind
from api.models.feed import IndexFeed
from gm_types.gaia import SLIDE_USER_TYPE, LOADING_POSITION


@bind('api/feed/matrix')
def feed_matrix(user_type=SLIDE_USER_TYPE.NEW_USER, loading=LOADING_POSITION.FIRST):
    """
    首页Matrix矩阵
    :param user_type: 用户类型
    :param loading: Loading
    :return:
    """
    queryset = IndexFeed.objects.filter(user_type=user_type, loading=loading, is_online=True).\
        order_by('ordering').values_list('card', flat=True)

    return list(queryset)
