# coding=utf8

from __future__ import (
    unicode_literals,
    absolute_import,
    print_function,
)

from django.db.models import Q
from django.utils import timezone

from community.models import Article
from rpc.decorators import (
    list_interface,
    bind,
    bind_context
)


@bind('community/article/list')
@list_interface(offset_name='start_num', limit_name='count')
def get_article_list(tabtype, start_num=0, count=10, with_count=False):
    """
    NOTE:
        Desc: 获取所长说/扒扒扒的列表页面
        :return:
        version: v5.6
    """
    now = timezone.now()

    query = Q(type=tabtype)
    query &= Q(is_online=True)
    query &= Q(start_time__lte=now)
    query &= (Q(end_time__gte=now) | Q(end_time__isnull=True))

    article_list = Article.objects.filter(query).order_by('-start_time')

    article_infos = []
    for info in article_list[start_num:start_num + count]:
        article_infos.append(info.to_dict())

    if not with_count:
        return article_infos

    return {
        'articles': article_infos,
        'total_count': article_list.count()
    }


@bind('community/article/type_list')
@list_interface(offset_name='start_num', limit_name='count')
def get_article_list(tabtype, start_num=0, count=10, show_type=0):
    now = timezone.now()

    query = Q(type=tabtype)
    query &= Q(is_online=True)
    query &= Q(start_time__lte=now)
    query &= (Q(end_time__gte=now) | Q(end_time__isnull=True))
    query &= (Q(send_channel_type=show_type))

    article_list = Article.objects.filter(query).order_by('-start_time')

    article_infos = []
    for info in article_list[start_num:start_num + count]:
        article_infos.append(info.to_dict())

    return article_infos
