#!/usr/bin/env python
# coding=utf-8
import datetime
import json
from django.utils import timezone

from rpc.context import get_rpc_remote_invoker
from message.views.push import doctor_noti_doctor_ids
from gm_types.push import PUSH_INFO_TYPE
from rpc.tool.protocol import PushUrlProtocol


def push_invite_answer(eta=None,):
    """
    把推送任务发送到Celery中
    """
    rpc_mimas = get_rpc_remote_invoker()
    start_t = datetime.datetime.now() + datetime.timedelta(-1)
    end_t = timezone.now()
    doctor_ids = rpc_mimas['qa/question/daily_push_doctors'](
        start_t=start_t.strftime('%Y-%m-%d %H:%M:%S'),
        end_t=end_t.strftime('%Y-%m-%d %H:%M:%S')
    ).unwrap()

    for doctor_id in doctor_ids.get('doctor_ids'):
        questions = rpc_mimas['qa/question/doctor_unread_count'](
            doctor_id=doctor_id
        ).unwrap()
        push_msg = u'爱美的用户向你咨询了%s个问题，快去为她们解答哦~' % questions
        doctor_noti_doctor_ids(doctor_ids=[doctor_id], platform=['android', 'iPhone'], push_time=end_t, alert=push_msg,
                               extra={
                    'type': PUSH_INFO_TYPE.GM_PROTOCOL,
                    'pushUrl': PushUrlProtocol.DOCTOR_QA_INVITE_ANSWER,
                },
        )
