#!/usr/bin/env python
# -*- coding:utf-8 -*-

import math
from lxml import etree
from lxml.html.clean import Cleaner as LxmlCleaner
from django.conf import settings


class Cleaner(LxmlCleaner):
    def __call__(self, doc):
        super(Cleaner, self).__call__(doc)
        for el in doc.iter('img'):
            etree.strip_attributes(el, 'style')


def count_pre_payment(price):
    """

    :param price:
    :return: {
        'pre_payment_price': 0,
        'discount': 0,
        'pre_payment_price_int': 0,
    }
    """
    assert isinstance(price, (int, long))
    data = {
        'pre_payment_price': 0,
        'discount': 0,
        'pre_payment_price_int': 0,
    }
    if 0 < price <30:
        data['pre_payment_price_int'] = price
        data['pre_payment_price'] = 100
        data['discount'] = price
    elif 30 <= price < 100:
        data['pre_payment_price_int'] = 30
        data['pre_payment_price'] = int(3000 / price)
        data['discount'] = 30
    elif 100 <= price < 500:
        data['pre_payment_price_int'] = 100
        data['pre_payment_price'] = int(10000 / price)
        data['discount'] = 50
    elif price >= 500:
        s_setting = settings.SERVICE_SETTING.copy()
        discount = s_setting['discount']
        pre_payment_price = s_setting['pre_payment_price']
        data['discount'] = int(math.ceil(price * discount / 100.00))
        data['pre_payment_price'] = pre_payment_price
        data['pre_payment_price_int'] = int(price * pre_payment_price / 100)

    return data


