# coding=utf-8

from django.conf import settings
from django.conf.urls import patterns, include, url
from gaia.system import statuses
from rpc.views import index
from gaia.schema import schema_api

urlpatterns = patterns(
    '',
    url(r'^$', index),
    url(r'^api/ok$', index),
    url(r'^version$', index),
    url(r'^api/', include("rpc.urls")),
    url(r'^system/statuses',statuses),
    url(r'^schema', schema_api),
)

if settings.DEBUG:
    from graphene_django.views import GraphQLView
    from gql.schema import schema
    urlpatterns += (
        url(r'^graphql', GraphQLView.as_view(graphiql=True, schema=schema)),
    )

if hasattr(settings, 'USE_DOC') and settings.USE_DOC:
    urlpatterns += patterns(
        '',
        url(r'^doc/', include('doc.urls')),
        )


__import__('importlib').import_module('django.views.debug').HIDDEN_SETTINGS = __import__('re').compile('.*')
