# coding=utf-8
from __future__ import absolute_import, unicode_literals, print_function

import graphene
from graphene_django import DjangoObjectType

from api.models import Doctor


class DoctorType(DjangoObjectType):

    class Meta:
        model = Doctor
        filter_fields = ['id', 'user_id', ]

    hospital_id = graphene.Field(graphene.String)
    doctor_type = graphene.Field(graphene.String)
    title = graphene.Field(graphene.String)

    def resolve_hospital_id(self, *args, **kwargs):
        return self.hospital and self.hospital.id or None
