# coding:utf-8
from django.db.models import Sum
from rpc.tool.queryset_tool import queryset_dec
__author__ = 'lp'


class MaidanOrderAction:
    @staticmethod
    def stat_trade(orders):
        """
        统计交易额
        """

        price_sum = orders.aggregate(t=Sum(u'payment_cent')).get('t') or 0
        price_sum /= 100
        return {
            "price_sum": price_sum,
        }


    @staticmethod
    def stat_discount(orders):
        """
        统计抽成
        """
        return {
            "discount": (orders.aggregate(discount=Sum('discount_cent')).get('discount'))/100,
        }
