# coding=utf8
from __future__ import unicode_literals, absolute_import, print_function

from api.models.audit import SimpleActionLog
from api.tool.datetime_tool import get_timestamp


def audit_write_log(user, package, action, object_type=None, object_id=None, message=None):
    sal = SimpleActionLog()
    sal.user = user
    sal.package_new = package
    sal.action_new = action
    sal.object_type = object_type
    sal.object_id = object_id
    sal.message = message
    sal.save(force_insert=True)


def get_audit_log_data(audit_log):
    assert isinstance(audit_log, SimpleActionLog)
    return {
        'id': audit_log.id,
        'action_time': get_timestamp(audit_log.action_time),
        'user_id': audit_log.user_id,
        'package': audit_log.package,
        'object_type': audit_log.object_type,
        'object_id': audit_log.object_id,
        'action': audit_log.action,
        'message': audit_log.message,
    }
