# coding=utf-8
import time
from django.core.management import BaseCommand
from api.models import WordRel
from api.models import Tag
from gm_types.gaia import TAG_TYPE, WORDREL_CATEGORY


class Command(BaseCommand):
    """
    python manage.py async_20190416_tag_to_wordrel
    同步旧标签中的 运营标签 到新标签库中
    """

    def handle(self, *args, **options):
        print 'loading....'
        try:
            all_tags = Tag.objects.filter(tag_type=TAG_TYPE.YUNYING, is_online=True)
            word_rel_syn_list = list()
            for tag in all_tags:
                word_rel_syn_list.append(WordRel(keyword=tag.name, category=WORDREL_CATEGORY.OPERATION))
            WordRel.objects.bulk_create(word_rel_syn_list)
            print 'result...', len(word_rel_syn_list)
        except Exception as ex:
            print 'error...', ex
        print 'Done!'
