# -*- coding: UTF-8 -*-

import datetime
from django.core.management import BaseCommand
from django.db.models import Q

from gm_types.gaia import HOSPITAL_TYPE, DOCTOR_TYPE

from api.models import Doctor


class Command(BaseCommand):
    """
        python manage.py update_20170810_merchant_doctor
        医生账号标记成为商户
    """

    def handle(self, *args, **options):
        q1 = Q(doctor_type=DOCTOR_TYPE.DOCTOR, hospital__hospital_type=HOSPITAL_TYPE.PUBLIC)
        q2 = Q(doctor_type=DOCTOR_TYPE.OFFICER, hospital__hospital_type=HOSPITAL_TYPE.PRIVATE)
        Doctor.objects.filter(q1|q2).update(is_merchant=True, become_merchant_time=datetime.datetime.now())
        print u'DONE!'
