# -*- coding: UTF-8 -*-
from django.conf import settings
from django.core.mail import EmailMessage, get_connection
from email.header import make_header


connection = get_connection(
    username=settings.HERA_EMAIL_USER,
    password=settings.HERA_EMAIL_PSWD,
)


def get_mail(sub, body, to_user_email, dt):
    if not isinstance(to_user_email, list):
        to_user_email = [to_user_email]
    mail = EmailMessage(connection=connection)
    mail.from_email = settings.HERA_EMAIL_USER
    mail.subject = sub
    mail.to = to_user_email
    mail.body = body
    title = make_header([(sub, 'utf-8')]).encode('utf-8')
    mail.attach(title, dt)
    return mail
