# coding=utf-8
from django.db.models import Q
from gm_types.gaia import ORDER_OPERATION_TYPE, ORDER_OPERATION_ROLE

from api.models import OrderOperation
from gm_dataquery.dataquery import DataSQLQuery, DataBuilder
from gm_dataquery.db import DB


class OrderOperationDB(DataBuilder):
    """
    订单操作日志实体返回数据格式
    """

    def getval_optype(self, obj):
        if obj.optype == ORDER_OPERATION_TYPE.REFUNDED:
            return u'标记状态:已退款'
        elif obj.optype == ORDER_OPERATION_TYPE.CASHBACKED:
            return u'标记状态:已返现'


@DB
class OrderOperationDQ(DataSQLQuery):
    """
    订单操作日志实体产生过滤
    """
    model = OrderOperation
    data_model = OrderOperationDB
