#!/usr/bin/env python
# -*- coding:utf-8 -*-
#
#   Author  :   RobertDing
#   E-mail  :   robertdingx@gmail.com
#   Date    :   17/10/26 17:01:33
#   Desc    :   用户举报
#

from gm_dataquery.db import DB
from gm_dataquery.dataquery import DataSQLQuery, DataBuilder

from api.models.report import ReportDoctor, ReportImages
from api.models import Doctor


class ReportDoctorDB(DataBuilder):
    def getval_images(self, item):
        return [x.image for x in item.images.all()]


@DB
class ReportDoctorDQ(DataSQLQuery):
    model = ReportDoctor
    data_model = ReportDoctorDB

    def create(self, **kwargs):
        images = kwargs.pop('images')
        if kwargs['doctor_id'] and not kwargs['hospital_id']:
            doctor = Doctor.objects.get(id=kwargs['doctor_id'])
            kwargs['hospital_id'] = doctor.hospital_id
        not kwargs['doctor_id'] and kwargs.pop('doctor_id')
        not kwargs['hospital_id'] and kwargs.pop('hospital_id')
        not kwargs['service_id'] and kwargs.pop('service_id')
        rd = ReportDoctor.objects.create(**kwargs)
        [ReportImages.objects.create(report=rd, image=x) for x in images]
        return {'id': rd.id}
