# -*- coding: UTF-8 -*-

from django.db.models import Q
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_dataquery.db import DB

from api.models import Reservation


class ReservationDB(DataBuilder):
    def getval_user(self, obj):
        return {
            'id': obj.user.id,
            'text': obj.user.last_name or obj.user.username,
        }

    def getval_address(self, obj):
        return obj.schedule.address.desc

    def getval_service(self, obj):
        return {
            'id': obj.order.service.id,
            'text': obj.order.service.name,
        }


@DB
class ReservationDQ(DataSQLQuery):
        model = Reservation
        data_model = ReservationDB

        def filter_doctor_id(self, srch_key, srch_val, regex=False):
            return Q(schedule__doctor__id=srch_val)
