# coding=utf-8
from django.db.models import Q

from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_dataquery.db import DB
from api.models import SKUPriceLog


class SKUPriceLogDB(DataBuilder):
    def getval_hospital_payment_price(self, obj):
        return obj.gengmei_price - obj.pre_payment_price

    def getval_discount_rate(self, obj):
        return int(obj.discount * 100 / obj.gengmei_price)

    def getval_valid_time(self, obj):
        start_time = str(obj.start_time).split('.')[0]
        return '{}-{}'.format(start_time, str(obj.end_time).split('.')[0]) if obj.end_time else start_time


@DB
class SKUPriceLogDQ(DataSQLQuery):

    model = SKUPriceLog
    data_model = SKUPriceLogDB
