# -*- coding: UTF-8 -*-

from django.db.models import Q
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_dataquery.db import DB

from api.models import SpecialExterior


class SpecialExteriorrDB(DataBuilder):
    def getval_seckill_polymer_id(self, obj):
        specialexterior = SpecialExterior.objects.filter(aggregate_type='2').first()
        return specialexterior.special_polymer_id if specialexterior else ''


@DB
class SpecialExteriorrDQ(DataSQLQuery):
    model = SpecialExterior
    data_model = SpecialExteriorrDB

    def filter_start_time(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)

    def filter_end_time(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)
