# -*- coding: UTF-8 -*-

from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_dataquery.db import DB

from talos.models.live import ZhiboConfig
from talos.services.user import UserService
from . import TalosDataSQLQuery


class ZhiboConfigDB(DataBuilder):
    def getval_anchor_name(self, obj):
        anchor_user = UserService.get_user_by_user_id(obj.anchor_user_id)
        return anchor_user.nickname


@DB
class ZhiboConfigDQ(TalosDataSQLQuery):
    model = ZhiboConfig
    data_model = ZhiboConfigDB

    def filter_start_time(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)

    def filter_end_time(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)

    def filter_zhibo_time(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)
