# encoding=utf-8
from __future__ import unicode_literals

from rpc.decorators import bind_context
from rpc.tool.dict_mixin import to_dict
from talos.models.live import ShortvideoBlackList
from hera.queries.talos.shortvideo import ShortvideoBlackListDQ
from hera.utils import model_edit


__author__ = 'Mingzhe Zou'

uri_pre = 'hera/shortvideo'


@bind_context(uri_pre + '/list')
def shortvideo_list(ctx, options):
    dtobj = ShortvideoBlackListDQ()
    return dtobj.process(**options)


@bind_context(uri_pre + '/get')
def shortvideo_detail(ctx, shortvideo_id, options=None):
    shortvideo_info = ShortvideoBlackList.objects.get(id=shortvideo_id)
    if options is None:
        options = {
            'fields': None,
            'excludes': None,
            'expands': None,
        }
    data = to_dict(shortvideo_info, **options)
    data['user_name'] = data['user_id']
    return data


@bind_context(uri_pre + '/modify')
def shortvideo_modify(ctx, shortvideo_id=None, shortvideo_info=None):
    shortvideo_info['user_id'] = shortvideo_info.pop('user_name')
    shortvideo_obj = model_edit(ShortvideoBlackList, shortvideo_id, shortvideo_info)
    return {'shortvideo_id': shortvideo_obj.id}
