#coding=utf-8
from django.core.management import BaseCommand

from api.models import Conversation,ConversationUserStatus

class Command(BaseCommand):
    """
    私信uid_hash重写
    python manage.py format_conversation_uid_hash
    """

    def handle(self, *args, **options):
        conversations = Conversation.objects.all()
        for conversation in conversations:
            print(conversation.id)
            user_objs = ConversationUserStatus.objects.filter(conversation_id=conversation.id)
            user_ids = []
            for item in user_objs:
                user_ids.append(item.user_id)
            conversation.uid_hash = Conversation.gen_uid_hash(user_ids)
            conversation.save()