# -*- coding: UTF-8 -*-

from django.core.management import BaseCommand
from hippo.models import Doctor
from hippo.tool.merchant_tool import MerchantProxy


class Command(BaseCommand):
    """
    往商户增加医生
    rels = {
        '商户的doctor_id': [
            '需要关联该商户的医生doctor_id',
            ...
        ],
    }
    """
    rels = {
        '79fbeca40f324c5dbfcc1d81ebefd07d': [
            '924688f067fd44bab4913a2cac12c5d8',
            '0b16a2e7e2174af09b3bd0cbae4cb6e4',
            '1b729c4a5e9a4d46b2b32110421102f3',
            'e0e2cf7c7f2f4bf9a83f0aae7443391d',
            'dd4c421f3cd44d2ba82c1a51e71806d8',
            'cb347f390c8c4998a45fcd89ca42a79f',
            'aecbbece30cb496e81d7f2df9105f2b5',
        ],
        'cd94e02d070f418e9d94ad71b1b5a438': [
            'cd94e02d070f418e9d94ad71b1b5a438',
            '0d4a7eb764744d7c8b44d388b8e34e88',
            'f4655e5e37a9407998a9d5737f5ee5dc',
            'd3d270cf69fe454e946541aefb82e839',
            'bf98640f1dab4e10a1a781a5c630a753',
            'a5cb3b1a940742e8b29919df5d776f5a',
            '0ee9b1916c864033a30b49d7c130d155',
        ],
        'd23f0856de6942b1bf4478611a547aa2': [
            'c729f2a4d4264f5199a4d2cfffc9d750',
            'c1438905afa0428eafcc4ac9ab9419e1',
            '880028f1f9264443968444c3161cd384',
            '51b5ddddc13b469d9a5e84f2efae35e7',
            '690ed3bc15574de6b59579a8b774f5c3',
            'cb5071a99f3b49759676d83e0aa019d7',
            '475ac028eab94bf087e5fc7599094d43',
            '7f7640fd7a784170a616f3d1ad8c61f5',
            '7440ba5b68f34e48b376e003af98a1dc',
            '1d29c5c32e204cf9b8dd73f248e0008a',
            'e413e6758f454ddabbad56e7827a8958',
            '736b342afc9a49e2981f46aa22f22896',
            '00b98eb66b294c0d8594d4016dce6835',
            'e62f69f4dc7b414b9eac1232d99e1366',
            '9a3a3599f30d49159f192e4bb28a8f10',
            '4c564d2249f74b1cac802c15be223c84',
            '34e3e4c5e697451591ba4ec17ae110aa',
            '7f5eb736dd2949feb54004ed762043e1',
            '3b126bec2a6a4a9b9f28593fc55ade1c',
            '33fef3847f6745c89e7024e66ada0427',
            '3fdaf747e09a4052988eb637e29b5741',
            'a6a83229ab93494a9389057bd0bffddf',
        ],
        '415b4190027a4fa08d32ab570d859951': [
            '577336c3cd434474b47ce399dfa793e4',
            'deb6cb20151c420c9d79334b110d2272',
            '928aeca9575e49efb04e657578bd8c53',
            '63691192361f4bd4b583b2e3d9bcfb4a',
            'e6deb90bd1754f54ba7b18d1ffcddabb',
            '0f7fd795450d4087b3b93cbd3c53f44e',
        ],
        'beijingyonghezhifayiyuan': [
            '5188f564436411e685d700163e0051d4',
            'b23662a43c3211e68a6300163e002fb3',
            'e3261c26a7b611e597aa00163e0042af',
            '9df1db96996411e58e0a00163e002fb3',
            '33f24d52996411e5837600163e0051d4',
            'fcef07be996311e583bb00163e000d0b',
            'shenzhenyonghezhifa',
            'guangzhouyonghezhifa',
            'shanghaiyonghezhifayiyuan',
            '76785490f40e11e6affe00163e0051d4',
            'c0e1dd22badd11e6a66c00163e0051d4',
            '73c08cacb3ab11e69cb000163e001c72',
            '3ffeb53aba8a11e5a10600163e000a4a',
            '17f5a618ba6511e5be9000163e000d0b',
            '25efd08ab84f11e589ea00163e0051d4',
            'f09a4c80b84e11e597f600163e000a4a',
            'ed7e755eaadd11e5a9c700163e0047b7',
            '3672b7bab84f11e5ad7300163e001c72',
            '18cdd6feba7011e5905a00163e000d0b',
        ],
        'd5cb5fe3f29147959047ba38746ee6ec': [
            'e301878b8c9944c19574e3bec370f163',
            'cc724c76e36d41129e319dc07af8a862',
            '5d9e557ce76d4244ab7dcaaa9b0f909b',
            'd0bd0df0513a426a99c9cdfaac621a7b',
            '3f51ee3092e7491cba0529349434599c',
            '9ab637cf34ac4b7bb4ef18eeba417ce4',
            'a6c1790761a644efa53ba62fa5327d3f',
            '49222770e70344199b7d3cda651bf233',
            'zhaoyang',
            'yangzhixiang',
            'zhouzonggui',
        ],
        'a82e013392c6493bb0e9e7e376418804': [
            '135c7f718dfb4f818bcec176fdbc3eb2',
            '05352c3099bf4263919eca2a42fc62bd',
            '87c35304ae604cc2b3a9bad558a7af7e',
            '95d7c86c9526408881f1c8ad01f4dd00',
            'e89f193e026c424185c3a5da65743678',
        ],
        'aa17616ef55511e5bdf100163e000a4a': [
            'd763aed4da184ad788d9ef1512acf2c3',
            '9b20378d79b846609c35729002505e64',
            '91ac05bb032e44a8b7e42508b3c89e7b',
            '9b91498d44fe4372af1597d89ddb3a1c',
            '8c729ed19b784f3ea7f5ac527c794930',
            '70dd4c88f55511e58f8d00163e0051d4',
            'f414e598d9c74a71a2f08a89f33e4755',
            '356a1bab0c9041769fb05dae8a7194ff',
            'c7fb866b9c784e2aa392fbe7a41b9590',
            'c14c0b20bd1711e6b71d00163e0051d4',
            '2659c5e453e011e6953f00163e0051d4',
        ],
    }

    def handle(self, *args, **options):
        for mch_did, doctor_ids in self.rels.iteritems():
            self.process_item(mch_did, doctor_ids)

    def process_item(self, mch_did, doctor_ids):
        mch_doctor = Doctor.objects.get(id=mch_did)
        doctors = Doctor.objects.filter(id__in=doctor_ids)

        merchant, _ = MerchantProxy.upsert_by_doctor(mch_doctor)
        merchant.add_rel_doctors([mch_doctor] + list(doctors))
        for doctor in doctors:
            mch = MerchantProxy.get_by_doctor(doctor)
            if mch is not None:
                mch.offline()
