# coding=utf-8
# create by oldman at 2018/9/18
from django.db import models
from hippo.models import Merchant


class MasterMerchant(models.Model):
    class Meta:
        verbose_name = u'主连锁商户'
        db_table = 'hippo_chain_merchant_master'
        app_label = 'hippo'

    mastermerchant = models.ForeignKey(Merchant, verbose_name=u'商户id', unique=True)
    is_login_related = models.BooleanField(verbose_name=u'是否账号登陆关联', default=False)
    is_message_related = models.BooleanField(verbose_name=u'是否私信关联', default=True)
    is_operetor_related = models.BooleanField(verbose_name=u'是否运营数据关联', default=False)
    is_store_classification = models.BooleanField(verbose_name=u'是否为旗舰店商户',default=False)

class SlaveMerchant(models.Model):
    class Meta:
        verbose_name = u'从连锁商户'
        db_table = 'hippo_chain_merchant_slave'
        app_label = 'hippo'

    mastermerchant = models.ForeignKey(MasterMerchant, verbose_name=u'关联主连锁商户', related_name='slavemerchants')
    slavemerchant = models.ForeignKey(Merchant, verbose_name=u'从连锁机构')
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)