# coding=utf-8
# create by oldman at 2017/12/10
from __future__ import division
import math
from datetime import datetime

from django.db import models

from hippo.models import Doctor


class Doctor_Extra(models.Model):
    class Meta:
        verbose_name = u'医生附属信息'
        db_table = 'hippo_doctor_extra'
        app_label = 'hippo'

    doctor = models.OneToOneField(Doctor, verbose_name=u'医生')
    professional_certificate_num = models.CharField(verbose_name=u'医生执业证书编号', default='', max_length=100)
    professional_certificate_time = models.DateField(verbose_name=u'医生职业证书注册时间', null=True)

    @property
    def working_year(self):
        if self.professional_certificate_time:
            return int(math.ceil(float((datetime.now().date() - self.professional_certificate_time).days) / 365))
        return 0


class Personalized_Label(models.Model):
    class Meta:
        verbose_name = u'个性化标签'
        db_table = 'hippo_personalized_label'
        app_label = 'hippo'

    name = models.CharField(verbose_name=u'名称', max_length=50)


class Doctor_Related_PersonalizedLabel(models.Model):
    class Meta:
        verbose_name = u'医生个性化标签关联表'
        db_table = 'hippo_doctor_related_personalizedlabel'
        app_label = 'hippo'

    doctor = models.ForeignKey(Doctor, verbose_name=u'医生', related_name='related_personalizedlabel')
    personalized_label = models.ForeignKey(Personalized_Label, verbose_name=u'个性化标签')


class RecommendService(models.Model):
    class Meta:
        verbose_name = u'医生推荐美购'
        db_table = 'hippo_recommend_service'
        app_label = 'hippo'

    doctor = models.ForeignKey(Doctor, verbose_name=u'医生ID')
    service_id = models.IntegerField(verbose_name=u'美购ID')
