#!/usr/bin/env python
# coding=utf-8

from __future__ import unicode_literals, absolute_import

from django.db import models

from api.models.bodypartsubitem import BodyPartSubItem
from api.models.tag import Tag

from .doctor import Doctor


class DoctorItem(models.Model):
    class Meta:
        verbose_name = u'360. 医生个人项目及价格'
        verbose_name_plural = u'360. 医生个人项目及价格'
        db_table = 'api_doctoritem'
        app_label = 'api'

    doctor = models.ForeignKey(Doctor, verbose_name=u"医生")
    item_name = models.CharField(max_length=40, verbose_name=u"项目名称")
    price_low = models.IntegerField(default=0, verbose_name=u"最低价格(元)")
    price_high = models.IntegerField(default=0, verbose_name=u"最高价格(元)")
    description = models.TextField(default=u"", null=True, blank=True, help_text=u"项目介绍")
    body_sub_items = models.ManyToManyField(BodyPartSubItem, related_name=u"doctoritem_subitem")
    is_deleted = models.BooleanField(default=False, verbose_name=u"是否删除")

    def __unicode__(self):
        return self.doctor.name + u"__" + self.item_name


class DoctorTag(models.Model):
    class Meta:
        verbose_name = u"医生标签"
        verbose_name_plural = u"医生标签"
        app_label = 'api'

    doctor = models.ForeignKey(Doctor)
    tag = models.ForeignKey(Tag)

    def __unicode__(self):
        return "%s:%s" % (self.tag.name, self.doctor.id)


class DocprojectTag(models.Model):
    class Meta:
        verbose_name = u'医生项目介绍标签'
        app_label = 'api'

    doctor = models.ForeignKey(Doctor)
    tag = models.ForeignKey(Tag)
    tag_content = models.TextField(default="", null=True, blank=True, verbose_name=u"项目介绍")

    def __unicode__(self):
        return "%s:%s" % (self.tag.name, self.doctor.id)
