# coding=utf-8
from __future__ import unicode_literals, absolute_import

from rpc.tool.error_code import gen
from rpc.tool.error_code import CODES
from api.models import Order
from api.models import ORDER_STATUS
from django.db import models


class ServiceSnapshotManager(models.Manager):
    def create(self, service, order):
        return super(ServiceSnapshotManager, self).create(
                order=order,
                service=service,
                name=service.name,
                short_description=service.short_description,
                detail_description=service.detail_description,
                exchange_points_ceiling=service.exchange_points_ceiling,
                doctor=service.doctor,
                hospital=service.hospital,
                special_remind=service.special_remind,
                ceiling_price=service.ceiling_price,
                payment_type=service.payment_type,
                channel=service.channel,
                service_flag=service.service_flag,
                phone=service.phone,
                sms_phone=service.sms_phone,
                pm_content=service.pm_content,
                address=service.address,
                is_online=service.is_online,
                is_sale=service.is_sale,
                is_voucher=service.is_voucher,
                ordering=service.ordering,
                total_num=service.total_num,
                start_time=service.start_time,
                end_time=service.end_time,
                update_time=service.update_time,
                only_use_points=service.only_use_points,
                single_user_buy_limit=service.single_user_buy_limit,
                need_address=service.need_address,
                need_sms_alert=service.need_sms_alert,
                bodypart_subitem=service.bodypart_subitem,
                image_header=service.image_header,
                image_detail=service.image_detail,
                is_multiattribute=service.is_multiattribute,
                share_get_cashback=service.share_get_cashback,
                refund_anytime=service.refund_anytime,
                compensation_in_advance=service.compensation_in_advance,
                cash_back_rate=service.cash_back_rate,
                fake_sold_num=service.fake_sold_num,
                notes=service.notes,
                show_location=service.show_location,
                tip=service.tip,
                rating=service.rating,
                operation_effect_rating=service.operation_effect_rating,
                doctor_attitude_rating=service.doctor_attitude_rating,
                hospital_env_rating=service.hospital_env_rating,
                is_operation=service.is_operation,
                is_vouchsafe=service.is_vouchsafe,
                wiki=service.wiki,
                is_stage=service.is_stage,
                reservation=service.reservation,
                valid_duration=service.valid_duration,
                points_deduction_percent=service.points_deduction_percent,
                recommend_usecase=service.recommend_usecase,
                is_self_support=service.is_self_support,
                business_partener=service.doctor.business_partener,
                # items = "",
                # item_key = "",

                self_support_discount=service.self_support_discount,
                discount=service.discount,

                pre_payment_price=service.pre_payment_price,
                total_price=service.total_price,
                original_price=service.original_price,
                gengmei_price=service.gengmei_price,
                max_gengmei_price=service.gengmei_price,
                is_floor_price=service.is_floor_price,
        )
