-- Deploy gaia:2017_06_29_api_columntab_create_table to mysql
-- 更美专栏(专栏tab，专栏tab关联tag，专栏作者，专栏内嵌入卡片)

BEGIN;

CREATE TABLE `api_columntab` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `name` varchar(10),
    `is_online` bool NOT NULL,
    `order` integer NOT NULL,
    `created_time` datetime(6) NOT NULL,
    `last_modified` datetime(6)
)
;
CREATE TABLE `api_columntabtag` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `column_tab_id` integer NOT NULL,
    `tag_id` integer NOT NULL
)
;
ALTER TABLE `api_columntabtag` ADD CONSTRAINT `column_tab_id_refs_id_80cb683a` FOREIGN KEY (`column_tab_id`) REFERENCES `api_columntab` (`id`);
CREATE TABLE `api_columnist` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `user_id` integer UNIQUE,
    `introduction` varchar(50),
    `is_online` bool NOT NULL
)
;
CREATE TABLE `api_columncard` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `article_id` integer NOT NULL,
    `service_id` integer,
    `doctor_id` varchar(100),
    `hospital_id` varchar(100)
)
;
ALTER TABLE `api_columncard` ADD CONSTRAINT `article_id_refs_id_6d5406c6` FOREIGN KEY (`article_id`) REFERENCES `api_problem` (`id`);

CREATE INDEX `api_columntabtag_b3de87b0` ON `api_columntabtag` (`column_tab_id`);
CREATE INDEX `api_columnist_1ffdedc6` ON `api_columnist` (`user_id`);
CREATE INDEX `api_columncard_e669cc35` ON `api_columncard` (`article_id`);
CREATE INDEX `api_columncard_5a8e60a2` ON `api_columncard` (`service_id`);
CREATE INDEX `api_columncard_3505b1b3` ON `api_columncard` (`doctor_id`);
CREATE INDEX `api_columncard_4963442f` ON `api_columncard` (`hospital_id`);

COMMIT;
