-- Deploy gaia:2017_12_02_point_mall to mysql
BEGIN;
CREATE TABLE `point_pointgoods` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `name` varchar(50) NOT NULL,
    `describe` varchar(100) NOT NULL,
    `thumb` varchar(100) NOT NULL,
    `image` varchar(100) NOT NULL,
    `goods_type` varchar(10) NOT NULL,
    `comment` varchar(200) NOT NULL,
    `channel_gift_id` integer NOT NULL,
    `point` integer NOT NULL,
    `create_time` datetime(6) NOT NULL
)
;
CREATE TABLE `point_pointactivity` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `name` varchar(50) NOT NULL,
    `describe` varchar(100) NOT NULL,
    `start_time` datetime(6) NOT NULL,
    `end_time` datetime(6) NOT NULL,
    `is_online` bool NOT NULL,
    `cost` integer NOT NULL,
    `activity_type` varchar(10) NOT NULL,
    `frequent_limit` integer NOT NULL,
    `placeholder` integer NOT NULL,
    `create_time` datetime(6) NOT NULL
)
;
CREATE TABLE `point_pointactivitygoods` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `stock` integer NOT NULL,
    `current_stock` integer NOT NULL,
    `order` integer NOT NULL,
    `point` integer NOT NULL,
    `level_limit` integer NOT NULL,
    `good_id` integer NOT NULL,
    `activity_id` integer NOT NULL,
    `weight` integer NOT NULL,
    `limit` integer NOT NULL,
    `base_count` integer NOT NULL,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL
)
;
ALTER TABLE `point_pointactivitygoods` ADD CONSTRAINT `activity_id_refs_id_9eb01059` FOREIGN KEY (`activity_id`) REFERENCES `point_pointactivity` (`id`);
ALTER TABLE `point_pointactivitygoods` ADD CONSTRAINT `good_id_refs_id_9be293c3` FOREIGN KEY (`good_id`) REFERENCES `point_pointgoods` (`id`);
CREATE TABLE `point_pointusergoods` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `user_id` integer NOT NULL,
    `point` integer NOT NULL,
    `user_level` integer NOT NULL,
    `express_no` varchar(100) NOT NULL,
    `activity_goods_id` integer,
    `activity_id` integer NOT NULL,
    `create_time` datetime(6) NOT NULL
)
;
ALTER TABLE `point_pointusergoods` ADD CONSTRAINT `activity_goods_id_refs_id_b8f46897` FOREIGN KEY (`activity_goods_id`) REFERENCES `point_pointactivitygoods` (`id`);
CREATE INDEX `point_pointactivitygoods_4a7ad2d3` ON `point_pointactivitygoods` (`good_id`);
CREATE INDEX `point_pointactivitygoods_8005e431` ON `point_pointactivitygoods` (`activity_id`);
CREATE INDEX `point_pointusergoods_a6ac01de` ON `point_pointusergoods` (`activity_goods_id`);
CREATE INDEX `point_pointusergoods_a6ac01d1` ON `point_pointusergoods` (`user_id`);
CREATE INDEX `point_pointusergoods_a6ac01d2` ON `point_pointusergoods` (`create_time`);
CREATE INDEX `point_pointusergoods_a6ac01d3` ON `point_pointusergoods` (`activity_id`);

CREATE TABLE `hera_config` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `key` varchar(50) NOT NULL,
    `value` varchar(200) NOT NULL,
    UNIQUE(`key`)
)
;
COMMIT;

CREATE TABLE `point_pointsnapshot` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `user_goods_id` integer NOT NULL UNIQUE,
    `user_exchange` longtext NOT NULL,
    `goods` longtext NOT NULL,
    `activity` longtext NOT NULL,
    `activity_goods` longtext NOT NULL,
    `extra` longtext NOT NULL
)
;
ALTER TABLE `point_pointsnapshot` ADD CONSTRAINT `user_goods_id_refs_id_e6a6a856` FOREIGN KEY (`user_goods_id`) REFERENCES `point_pointusergoods` (`id`);
