-- Deploy gaia:2019-6-19_create_aglie_models to mysql

BEGIN;

-- XXX Add DDLs here.

CREATE TABLE `api_agile_tag` (
              `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
              `is_online` bool NOT NULL,
              `create_time` datetime(6) NOT NULL,
              `update_time` datetime(6) NOT NULL,
              `name` varchar(128) NOT NULL UNIQUE,
              `description` longtext NOT NULL,
              `create_tag_type` varchar(3) NOT NULL,
              `style` varchar(3) NOT NULL,
              `topic_recommend_sort` integer NOT NULL);


CREATE TABLE `api_agile_tag_mapping` (
              `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
              `is_online` bool NOT NULL,
              `create_time` datetime(6) NOT NULL,
              `update_time` datetime(6) NOT NULL,
              `agile_tag_id` integer NOT NULL,
              `old_tag_id` integer NOT NULL);


CREATE TABLE `api_agile_tag_recommend_type` (
              `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
              `is_online` bool NOT NULL,
              `create_time` datetime(6) NOT NULL,
              `update_time` datetime(6) NOT NULL,
              `agile_tag_id` integer NOT NULL,
              `agile_tag_type` varchar(3) NOT NULL);


CREATE TABLE `api_agile_tag_relation_polymer` (
              `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
              `is_online` bool NOT NULL,
              `create_time` datetime(6) NOT NULL,
              `update_time` datetime(6) NOT NULL,
              `agile_tag_id` integer NOT NULL,
              `polymer_id` integer NOT NULL);


CREATE TABLE `api_agile_tag_type` (
              `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
              `is_online` bool NOT NULL,
              `create_time` datetime(6) NOT NULL,
              `update_time` datetime(6) NOT NULL,
              `agile_tag_id` integer NOT NULL,
              `agile_tag_type` varchar(3) NOT NULL);


CREATE INDEX `api_agile_tag_mapping_46e92b39` ON `api_agile_tag_mapping` (`agile_tag_id`);


CREATE INDEX `api_agile_tag_mapping_e85ff166` ON `api_agile_tag_mapping` (`old_tag_id`);


CREATE INDEX `api_agile_tag_recommend_type_46e92b39` ON `api_agile_tag_recommend_type` (`agile_tag_id`);


CREATE INDEX `api_agile_tag_relation_polymer_46e92b39` ON `api_agile_tag_relation_polymer` (`agile_tag_id`);


CREATE INDEX `api_agile_tag_relation_polymer_d6993334` ON `api_agile_tag_relation_polymer` (`polymer_id`);


CREATE INDEX `api_agile_tag_type_46e92b39` ON `api_agile_tag_type` (`agile_tag_id`);

COMMIT;
