-- Deploy gaia:2019_10_14_create_api_freerecruitment_table to mysql

BEGIN;

-- XXX Add DDLs here.
CREATE TABLE `api_freerecruitment` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `title` varchar(128) NOT NULL,
    `deposit` integer,
    `quota` integer NOT NULL,
    `start_time` datetime(6) NOT NULL,
    `end_time` datetime(6),
    `service_id` integer,
    `list_image` varchar(128) NOT NULL,
    `recruitment_rules` longtext NOT NULL,
    `diary_requirements` longtext NOT NULL,
    `careful_matter` longtext NOT NULL,
    `is_synchronize_app` bool NOT NULL,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL
)
;
ALTER TABLE `api_freerecruitment` ADD CONSTRAINT `service_id_refs_id_073dae98` FOREIGN KEY (`service_id`) REFERENCES `api_service` (`id`);
CREATE INDEX `api_freerecruitment_91a0ac17` ON `api_freerecruitment` (`service_id`);
CREATE INDEX `api_freerecruitment_c3bd43a2` ON `api_freerecruitment` (`update_time`);

CREATE TABLE `api_freerecruitment_image` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `freerecruitment_id` integer NOT NULL,
    `image` varchar(128) NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL
)
;
ALTER TABLE `api_freerecruitment_image` ADD CONSTRAINT `freerecruitment_id_refs_id_51fd724e` FOREIGN KEY (`freerecruitment_id`) REFERENCES `api_freerecruitment` (`id`);
CREATE INDEX `api_freerecruitment_image_0427bea2` ON `api_freerecruitment_image` (`freerecruitment_id`);
CREATE INDEX `api_freerecruitment_image_c3bd43a2` ON `api_freerecruitment_image` (`update_time`);

CREATE TABLE `api_freerecruitment_diary` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `freerecruitment_id` integer NOT NULL,
    `diary_id` integer,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL
)
;
ALTER TABLE `api_freerecruitment_diary` ADD CONSTRAINT `diary_id_refs_id_6d40525d` FOREIGN KEY (`diary_id`) REFERENCES `api_diary` (`id`);
ALTER TABLE `api_freerecruitment_diary` ADD CONSTRAINT `freerecruitment_id_refs_id_145e1369` FOREIGN KEY (`freerecruitment_id`) REFERENCES `api_freerecruitment` (`id`);
CREATE INDEX `api_freerecruitment_diary_0427bea2` ON `api_freerecruitment_diary` (`freerecruitment_id`);
CREATE INDEX `api_freerecruitment_diary_67548958` ON `api_freerecruitment_diary` (`diary_id`);
CREATE INDEX `api_freerecruitment_diary_c3bd43a2` ON `api_freerecruitment_diary` (`update_time`);

CREATE TABLE `api_freerecruitment_doctor` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `freerecruitment_id` integer NOT NULL,
    `doctor_id` varchar(100),
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL
)
;
ALTER TABLE `api_freerecruitment_doctor` ADD CONSTRAINT `doctor_id_refs_id_5cbd011d` FOREIGN KEY (`doctor_id`) REFERENCES `api_doctor` (`id`);
ALTER TABLE `api_freerecruitment_doctor` ADD CONSTRAINT `freerecruitment_id_refs_id_ee96e3a3` FOREIGN KEY (`freerecruitment_id`) REFERENCES `api_freerecruitment` (`id`);
CREATE INDEX `api_freerecruitment_doctor_0427bea2` ON `api_freerecruitment_doctor` (`freerecruitment_id`);
CREATE INDEX `api_freerecruitment_doctor_72821be1` ON `api_freerecruitment_doctor` (`doctor_id`);
CREATE INDEX `api_freerecruitment_doctor_c3bd43a2` ON `api_freerecruitment_doctor` (`update_time`);

CREATE TABLE `api_freerecruitmentuser` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `freerecruitment_id` integer NOT NULL,
    `user_id` integer NOT NULL,
    `name` varchar(128) NOT NULL,
    `sex` varchar(2) NOT NULL,
    `age` integer NOT NULL,
    `user_phone` varchar(20) NOT NULL,
    `full_face_photo` varchar(128),
    `left_45_degrees` varchar(128),
    `right_45_degrees` varchar(128),
    `left_image` varchar(128),
    `right_image` varchar(128),
    `has_cosmetic_history` bool NOT NULL,
    `has_medical_history` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL
)
;
ALTER TABLE `api_freerecruitmentuser` ADD CONSTRAINT `user_id_refs_id_5c5b02bb` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`);
ALTER TABLE `api_freerecruitmentuser` ADD CONSTRAINT `freerecruitment_id_refs_id_b5bf6721` FOREIGN KEY (`freerecruitment_id`) REFERENCES `api_freerecruitment` (`id`);
CREATE INDEX `api_freerecruitmentuser_0427bea2` ON `api_freerecruitmentuser` (`freerecruitment_id`);
CREATE INDEX `api_freerecruitmentuser_6340c63c` ON `api_freerecruitmentuser` (`user_id`);
CREATE INDEX `api_freerecruitmentuser_fda69753` ON `api_freerecruitmentuser` (`age`);
CREATE INDEX `api_freerecruitmentuser_c3bd43a2` ON `api_freerecruitmentuser` (`update_time`);

CREATE TABLE `api_assistanceuser` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `freerecruitment_id` integer NOT NULL,
    `user_id` integer NOT NULL,
    `assister_id` integer NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL
)
;
ALTER TABLE `api_assistanceuser` ADD CONSTRAINT `assister_id_refs_id_7f9be1a1` FOREIGN KEY (`assister_id`) REFERENCES `auth_user` (`id`);
ALTER TABLE `api_assistanceuser` ADD CONSTRAINT `user_id_refs_id_9c6eb737` FOREIGN KEY (`user_id`) REFERENCES `api_freerecruitmentuser` (`id`);
ALTER TABLE `api_assistanceuser` ADD CONSTRAINT `freerecruitment_id_refs_id_5056115d` FOREIGN KEY (`freerecruitment_id`) REFERENCES `api_freerecruitment` (`id`);
CREATE INDEX `api_assistanceuser_0427bea2` ON `api_assistanceuser` (`freerecruitment_id`);
CREATE INDEX `api_assistanceuser_6340c63c` ON `api_assistanceuser` (`user_id`);
CREATE INDEX `api_assistanceuser_eb03a391` ON `api_assistanceuser` (`assister_id`);
CREATE INDEX `api_assistanceuser_c3bd43a2` ON `api_assistanceuser` (`update_time`);

CREATE TABLE `api_reservationuser` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `freerecruitment_id` integer NOT NULL,
    `user_id` integer NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL
)
;
ALTER TABLE `api_reservationuser` ADD CONSTRAINT `user_id_refs_id_01d6a585` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`);
ALTER TABLE `api_reservationuser` ADD CONSTRAINT `freerecruitment_id_refs_id_5228768e` FOREIGN KEY (`freerecruitment_id`) REFERENCES `api_freerecruitment` (`id`);
CREATE INDEX `api_reservationuser_0427bea2` ON `api_reservationuser` (`freerecruitment_id`);
CREATE INDEX `api_reservationuser_6340c63c` ON `api_reservationuser` (`user_id`);
CREATE INDEX `api_reservationuser_c3bd43a2` ON `api_reservationuser` (`update_time`);


COMMIT;
