-- Deploy gaia:api_2015_11_17_create_tables_for_order to mysql

BEGIN;
CREATE TABLE `api_orderoperation` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `order_id` varchar(12) NOT NULL,
    `operator_id` char(32) NOT NULL,
    `optype` integer NOT NULL,
    `role` integer NOT NULL,
    `source` varchar(1) NOT NULL,
    `operate_at` datetime(6)
)
;
ALTER TABLE `api_orderoperation` ADD CONSTRAINT `order_id_refs_id_0ae532e4` FOREIGN KEY (`order_id`) REFERENCES `api_order` (`id`);
ALTER TABLE `api_orderoperation` ADD CONSTRAINT `operator_id_refs_id_cdade4a5` FOREIGN KEY (`operator_id`) REFERENCES `api_person` (`id`);


CREATE TABLE `api_cashbackorder` (
    `id` varchar(15) NOT NULL PRIMARY KEY,
    `order_id` varchar(12) NOT NULL UNIQUE,
    `fee` integer,
    `status` integer NOT NULL,
    `created_at` datetime(6) NOT NULL,
    `updated_at` datetime(6) NOT NULL,
    `cashbacked_at` datetime(6),
    `source` varchar(1) NOT NULL
)
;
ALTER TABLE `api_cashbackorder` ADD CONSTRAINT `order_id_refs_id_fec20c35` FOREIGN KEY (`order_id`) REFERENCES `api_order` (`id`);
CREATE TABLE `api_refundorder` (
    `id` varchar(15) NOT NULL PRIMARY KEY,
    `order_id` varchar(12) NOT NULL UNIQUE,
    `fee` integer,
    `status` integer NOT NULL,
    `doctor_id` varchar(100),
    `doctor_reason` longtext NOT NULL,
    `user_reason` longtext NOT NULL,
    `created_at` datetime(6) NOT NULL,
    `updated_at` datetime(6) NOT NULL,
    `refunded_at` datetime(6),
    `source` varchar(1) NOT NULL
)
;
ALTER TABLE `api_refundorder` ADD CONSTRAINT `doctor_id_refs_id_176f6301` FOREIGN KEY (`doctor_id`) REFERENCES `api_doctor` (`id`);
ALTER TABLE `api_refundorder` ADD CONSTRAINT `order_id_refs_id_b17acb82` FOREIGN KEY (`order_id`) REFERENCES `api_order` (`id`);

COMMIT;
