-- Deploy gaia:api_2016_08_23_add_tables_for_doctor_upload_service to mysql

BEGIN;

-- XXX Add DDLs here.
CREATE TABLE `api_servicereviewrecord` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `person_id` char(32) NOT NULL,
    `update_data` longtext NOT NULL,
    `serviceregister_id` integer NOT NULL,
    `created_time` datetime(6),
    `now_review_status` varchar(8) NOT NULL,
    `review_type` varchar(8) NOT NULL,
    `reason` varchar(1000)
)
;
ALTER TABLE `api_servicereviewrecord` ADD CONSTRAINT `serviceregister_id_refs_id_0a250014` FOREIGN KEY (`serviceregister_id`) REFERENCES `api_serviceregister` (`id`);
ALTER TABLE `api_servicereviewrecord` ADD CONSTRAINT `person_id_refs_id_75727732` FOREIGN KEY (`person_id`) REFERENCES `api_person` (`id`);
CREATE TABLE `api_tagattr` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `tag_id` integer  NULL,
    `name` varchar(200) NOT NULL,
    `is_online` bool NOT NULL,
    `created_time` datetime(6)
)
;
ALTER TABLE `api_tagattr` ADD CONSTRAINT `tag_id_refs_id_e2265b2e` FOREIGN KEY (`tag_id`) REFERENCES `api_tag` (`id`);
CREATE TABLE `api_attroptions` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `name` varchar(200) NOT NULL,
    `is_online` bool NOT NULL,
    `created_time` datetime(6),
    `is_doctor_create` bool NOT NULL,
    `tag_attr_id` integer  NULL
)
;
ALTER TABLE `api_attroptions` AUTO_INCREMENT=60000;
ALTER TABLE `api_attroptions` ADD CONSTRAINT `tag_attr_id_refs_id_3ee188bb` FOREIGN KEY (`tag_attr_id`) REFERENCES `api_tagattr` (`id`);
CREATE TABLE `api_serviceitemkey` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `serviceitem_id` integer NOT NULL,
    `serviceattroption_id` integer NOT NULL
)
;
ALTER TABLE `api_serviceitemkey` ADD CONSTRAINT `serviceattroption_id_refs_id_859586d6` FOREIGN KEY (`serviceattroption_id`) REFERENCES `api_attroptions` (`id`);
ALTER TABLE `api_serviceitemkey` ADD CONSTRAINT `serviceitem_id_refs_id_bb674ee5` FOREIGN KEY (`serviceitem_id`) REFERENCES `api_serviceitem` (`id`);
CREATE TABLE `api_serviceregisteritemkey` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `serviceregisteritem_id` integer NOT NULL,
    `serviceregisterattroption_id` integer NOT NULL
)
;
ALTER TABLE `api_serviceregisteritemkey` ADD CONSTRAINT `serviceregisterattroption_id_refs_id_137a11ee` FOREIGN KEY (`serviceregisterattroption_id`) REFERENCES `api_attroptions` (`id`);
ALTER TABLE `api_serviceregisteritemkey` ADD CONSTRAINT `serviceregisteritem_id_refs_id_a0ae60ee` FOREIGN KEY (`serviceregisteritem_id`) REFERENCES `api_serviceregisteritem` (`id`);


CREATE TABLE `api_uploadbutton` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `button_document` varchar(100) NOT NULL,
    `start_show_time` datetime(6) NOT NULL,
    `end_show_time` datetime(6) NOT NULL,
    `start_sell_time` datetime(6) NOT NULL,
    `end_sell_time` datetime(6) NOT NULL,
    `button_prefix` varchar(100) NOT NULL,
    `discount` integer NOT NULL
)
;

ALTER TABLE `api_serviceregister` ADD COLUMN `upload_button_id` INT NULL DEFAULT NULL;

ALTER TABLE `api_serviceregister` ADD CONSTRAINT `upload_button_id_refs_id_137a11eF` FOREIGN KEY (`upload_button_id`) REFERENCES `api_uploadbutton` (`id`);




COMMIT;
