-- Deploy gaia:api_2017_07_12_create_rankboard to mysql

BEGIN;

CREATE TABLE `api_rankboard` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `title` varchar(30) NOT NULL,
    `image` varchar(300) NOT NULL,
    `type` varchar(2) NOT NULL,
    `describe` varchar(200) NOT NULL,
    `rank` integer NOT NULL,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `datapool_last_modified` datetime(6),
    `share_id` integer NOT NULL
)
;
ALTER TABLE `api_rankboard` ADD CONSTRAINT `share_id_refs_id_8ed7bf0b` FOREIGN KEY (`share_id`) REFERENCES `api_share` (`id`);
CREATE TABLE `api_rankboardshowregion` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `rankboard_id` integer NOT NULL,
    `region_id` integer NOT NULL
)
;
ALTER TABLE `api_rankboardshowregion` ADD CONSTRAINT `region_id_refs_id_11fed85e` FOREIGN KEY (`region_id`) REFERENCES `api_region` (`id`);
ALTER TABLE `api_rankboardshowregion` ADD CONSTRAINT `rankboard_id_refs_id_a13ef1a4` FOREIGN KEY (`rankboard_id`) REFERENCES `api_rankboard` (`id`);
CREATE TABLE `api_rankboardshowcity` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `rankboard_id` integer NOT NULL,
    `city_id` varchar(40) NOT NULL
)
;
ALTER TABLE `api_rankboardshowcity` ADD CONSTRAINT `rankboard_id_refs_id_d5f4f362` FOREIGN KEY (`rankboard_id`) REFERENCES `api_rankboard` (`id`);
ALTER TABLE `api_rankboardshowcity` ADD CONSTRAINT `city_id_refs_id_5ec7f9be` FOREIGN KEY (`city_id`) REFERENCES `api_city` (`id`);
CREATE TABLE `api_rankboarddatatag` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `rankboard_id` integer NOT NULL,
    `tag_id` integer NOT NULL
)
;
ALTER TABLE `api_rankboarddatatag` ADD CONSTRAINT `tag_id_refs_id_16fa8600` FOREIGN KEY (`tag_id`) REFERENCES `api_tag` (`id`);
ALTER TABLE `api_rankboarddatatag` ADD CONSTRAINT `rankboard_id_refs_id_e6013f63` FOREIGN KEY (`rankboard_id`) REFERENCES `api_rankboard` (`id`);
CREATE TABLE `api_rankboardconnect` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `rankboard_id` integer NOT NULL,
    `to_rankboard_id` integer NOT NULL
)
;
ALTER TABLE `api_rankboardconnect` ADD CONSTRAINT `rankboard_id_refs_id_938cc7d4` FOREIGN KEY (`rankboard_id`) REFERENCES `api_rankboard` (`id`);
ALTER TABLE `api_rankboardconnect` ADD CONSTRAINT `to_rankboard_id_refs_id_938cc7d4` FOREIGN KEY (`to_rankboard_id`) REFERENCES `api_rankboard` (`id`);
CREATE TABLE `api_rankboarddata` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `rankboard_id` integer NOT NULL,
    `hospital_id` varchar(100),
    `service_id` integer,
    `doctor_id` varchar(100),
    `status` varchar(2) NOT NULL,
    `describe` varchar(100) NOT NULL,
    `rank` integer NOT NULL
)
;
ALTER TABLE `api_rankboarddata` ADD CONSTRAINT `hospital_id_refs_id_2a8df08c` FOREIGN KEY (`hospital_id`) REFERENCES `api_hospital` (`id`);
ALTER TABLE `api_rankboarddata` ADD CONSTRAINT `service_id_refs_id_2c0dc02f` FOREIGN KEY (`service_id`) REFERENCES `api_service` (`id`);
ALTER TABLE `api_rankboarddata` ADD CONSTRAINT `rankboard_id_refs_id_3f735fd0` FOREIGN KEY (`rankboard_id`) REFERENCES `api_rankboard` (`id`);
ALTER TABLE `api_rankboarddata` ADD CONSTRAINT `doctor_id_refs_id_7ac0813c` FOREIGN KEY (`doctor_id`) REFERENCES `api_doctor` (`id`);

ALTER TABLE `api_columncard`
ADD COLUMN `answer_id` integer,
ADD COLUMN `rankboard_id` integer;
CREATE INDEX `api_columncard_8fba58e3` ON `api_columncard` (`answer_id`);
CREATE INDEX `api_columncard_66ee2858` ON `api_columncard` (`rankboard_id`);

COMMIT;
