-- Deploy gaia:api_2018_09_05_add_lipstick_table to mysql

BEGIN;

CREATE TABLE `lipstick_prize` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `activity_id` integer NOT NULL,
    `name` varchar(100) NOT NULL,
    `rank` integer NOT NULL,
    `image` varchar(200) NOT NULL,
    `type` smallint NOT NULL,
    `stock` integer NOT NULL,
    `prob` integer NOT NULL,
    `is_online` bool NOT NULL DEFAULT 1,
    `channel_gift_id` integer,
    `points` integer NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `draw_count` integer NOT NULL
)
;

ALTER TABLE `lipstick_prize` ADD CONSTRAINT `activity_id_refs_id_5bdd5ff2` FOREIGN KEY (`activity_id`) REFERENCES `api_variety_activity` (`id`);
ALTER TABLE `lipstick_prize` ADD CONSTRAINT `channel_gift_id_refs_id_814302d7` FOREIGN KEY (`channel_gift_id`) REFERENCES `api_channelgift` (`id`);
CREATE TABLE `lipstick_record` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `item_id` integer NOT NULL,
    `user_id` integer NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `express_info` longtext,
    `is_online` bool NOT NULL
)
;

ALTER TABLE `lipstick_record` ADD CONSTRAINT `item_id_refs_id_0008a4ad` FOREIGN KEY (`item_id`) REFERENCES `lipstick_prize` (`id`);
ALTER TABLE `lipstick_record` ADD CONSTRAINT `user_id_refs_id_2854e00a` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`);


ALTER TABLE `hera_config` MODIFY COLUMN `value` longtext NOT NULL;
ALTER TABLE `hera_config` MODIFY COLUMN `key` varchar(200) NOT NULL;
ALTER TABLE `api_variety_activity` ADD COLUMN `others_banner_config` longtext DEFAULT NULL;
COMMIT;
